namespace FactoryAndStrategy.MessageServices;
public class MessageServiceFactory
{
    IMessageService? smsService = null;
    IMessageService? emailService = null;
    IMessageService? voiceMessageService = null;
    public IMessageService CreateMessageService(MessageType messageType)
    {
        return messageType switch
        {
            MessageType.SMS => smsService ??= new SMSService(),
            MessageType.Email => emailService ??= new EmailMessageService(),
            MessageType.VoiceCall => voiceMessageService ??= new VoiceMessageService(),
            _ => throw new ArgumentException("Invalid sender type"),
        };
    }
}